<?php
require_once 'config.php';

class Auth {
    public static function login($username, $password) {
        $db = Config::getDB();
        $stmt = $db->prepare("SELECT * FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$username, $username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['user_type'] = $user['user_type'];
            $_SESSION['email'] = $user['email'];
            return true;
        }
        return false;
    }
    
    public static function register($username, $email, $password, $user_type = 'student') {
        $db = Config::getDB();
        $password_hash = password_hash($password, PASSWORD_DEFAULT);
        
        try {
            $stmt = $db->prepare("INSERT INTO users (username, email, password_hash, user_type) VALUES (?, ?, ?, ?)");
            return $stmt->execute([$username, $email, $password_hash, $user_type]);
        } catch (PDOException $e) {
            error_log("Registration failed: " . $e->getMessage());
            return false;
        }
    }
    
    public static function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }
    
    public static function isAdmin() {
        return isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'admin';
    }
    
    public static function logout() {
        session_destroy();
        session_start(); // Start new session for flash messages if needed
    }
    
    // Create an admin user if none exists
    public static function createDefaultAdmin() {
        $db = Config::getDB();
        
        $stmt = $db->prepare("SELECT COUNT(*) as count FROM users WHERE user_type = 'admin'");
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result['count'] == 0) {
            $default_password = 'admin123'; // Change this!
            $password_hash = password_hash($default_password, PASSWORD_DEFAULT);
            
            $stmt = $db->prepare("INSERT INTO users (username, email, password_hash, user_type) VALUES (?, ?, ?, ?)");
            $stmt->execute(['admin', 'admin@cbt.com', $password_hash, 'admin']);
            
            error_log("Default admin created: admin / admin123");
        }
    }
}

// Create default admin if needed
Auth::createDefaultAdmin();
?>