<?php
require_once 'ExamManager.php';
require_once 'auth.php';

if (!Auth::isLoggedIn()) {
    die(json_encode(['success' => false, 'error' => 'Unauthorized']));
}

$session_id = intval($_POST['session_id'] ?? 0);
$question_index = intval($_POST['question_index'] ?? 0);
$answer = Config::sanitize($_POST['answer'] ?? '');
$time_spent = intval($_POST['time_spent'] ?? 0);
$time_left = intval($_POST['time_left'] ?? 0);

if ($session_id === 0) {
    die(json_encode(['success' => false, 'error' => 'Invalid session']));
}

$result = ExamManager::saveAnswer($session_id, $question_index, $answer, $time_spent, $time_left);

if ($result) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to save answer']);
}
?>